﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "Beachten Sie bitte, dass alle während der Produktaktivierung gesammelten Daten im Einklang mit den Autodesk ";
var xmsgOfflinePrivacyWarning= "Wenn keine Verbindung mit dem Internet besteht, legen Sie für die Codierung im Internet Explorer (R) die automatische Auswahl fest, um die Datenschutzrichtlinien anzuzeigen. Besteht eine Verbindung mit dem Internet, können Sie die Datenschutzrichtlinien auch online über die Autodesk-Website unter autodesk.com aufrufen."
////////////////////////////////////////////////////

var xmsgProductLanguage=	"de";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"Autorisierung bestätigt";
var xmsgRTActLicFound=                  "Aktivierte Lizenz gefunden";
var xmsgRTActLicFoundError=            "Registrierungs-/Aktivierungsfehler"; 
var xmsgRTAuthEntryError=				"Aktivierungseingabefehler";
var xmsgRTAuthError=					"Aktivierungsfehler";
var xmsgRTAuthNow=						"Jetzt autorisieren";
var xmsgRTBeginReg=						"Registrierung starten";
var xmsgRTBuyInformation=				"Kaufinformationen";
var xmsgRTConfirm=						"Benutzerbestätigung";
var xmsgRTConnect=						"Verbindung";
var xmsgRTConnectFail=					"Verbindungsfehler";
var xmsgRTContactAutodesk=				"Autodesk kontaktieren";
var xmsgRTCountryPage=					"Land";
var xmsgRTEmail=						"E-Mail";
var xmsgRTFaxUS=						"Benutzerfax";
var xmsgRTMailUS=						"Benutzeranschrift";
var xmsgRTPurchaseOffline=				"Offline kaufen";
var xmsgRTRegConfirmed=					"Registrierungsbestätigung";
var xmsgRTExportConfirm=                "Lizenzexportbestätigung";
var xmsgRTImportConfirm=                "Lizenzimportbestätigung"; 
var xmsgRTRegVol=						"Produkt registrieren";
var xmsgRTSUNDataConfirm=				"SUN - Datenbestätigung";
var xmsgRTSUNServer=					"SUN-Server";
var xmsgRTSUNSubmit=					"Benutzerbestätigung - SUN";
var xmsgRTUserInfo=						"Benutzerinformationen";
var xmsgRTLicFileSaveError=				"Flexlm-Lizenzdatei-Speicherfehler";
var xmsgRTProductInfo=                   "Produktinformation"; //add by joyce.min on 2007-8-14
var xmsgNSARTBegin=						"Eine Netzwerklizenz erhalten";
var xmsgNSARTLocateLicense=				"Lizenzdatei suchen";
var xmsgNSARTEditServerAndSeat=			"Eingabe von Änderungs-Server-Informationen";
var xmsgNSARTConfirmServerAndSeat=		"Server-Informationen bestätigen";
var xmsgNSARTEnterSN=					"Seriennummer eingeben";
var xmsgProcessingError=				"Verarbeitungsfehler";
var xmsgTimeout=        				"Zeitüberschreitung bei dieser Sitzung";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"Aktivierung für:";
var xmsgPurchase=       "Kauf:";
var xmsgRegistrationFor=       "Registrierung für:";
var xmsgProduct=	"Produkt: ";
var xmsgsernum=		"Seriennummer: ";
var xmsgsernumWGID=	"Seriennummer oder Gruppen-ID: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "Produktschlüssel: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"Bisherige Seriennummer: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"Bisherige Seriennummer:*";
var xmsgNewSernum1=	"Geben Sie Ihre Seriennummer oder Gruppen-ID ein:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"Anforderungscode: ";
var xmsgRegAuthCode=	"Aktivierungscode: ";
var xmsgApplicationKey=	"Anwendungsschlüssel: ";
var xmsgRTHostID=				"Host-ID:";
var xmsgRTFlexlmLicenseFile=	"Lizenzdatei:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Anrede:";
var xmsgNone=		"(keine)";
var xmsgNotEntered=	"(nicht eingegeben)";
var xmsgFirstname=	"Vorname:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"Vorname (Kanji):";
var xmsgFirstnameFurigana=	"Vorname (Zenkaku Kana):";
var xmsgLastname=	"Nachname:";
var xmsgLastnameKanji=	"Nachname (Kanji):";
var xmsgLastnameFurigana=	"Nachname (Zenkaku Kana):";
var xmsgCompanyName=	"Firma:*";
var xmsgCompanyName2=	"Firma:";
var xmsgCompanyNameJP=	"Firmenname (Kanji):";
var xmsgPhone=		"Telefon:";
var xmsgArea=		"Region:";
var xmsgNumber=		"Nummer:";
var xmsgExt=		"Anschluss:";
var xmsgFax=		"Fax:";
var xmsgFaxTo=		"Fax an ";
var xmsgEmail=		"E-Mail:";
var xmsgEmailTo=	"E-Mail an ";
var xmsgAddress=	"Straßenadresse:";
var xmsgAddress2=	"Straßenadresse 2:";
var xmsgAddress3=	"Straßenadresse 3:";
var xmsgJPAddress=	"Stadt:";
var xmsgJPAddress2=	"Straßenadresse:";
var xmsgJPAddress3=	"Gebäude (und Etage):";
var xmsgCity=		"Stadt:";
var xmsgSRP=		"Bundesland/Bundesstaat/Region/Provinz/Kanton:";
var xmsgStText=		"Bundesland:";
var xmsgPrText=		"Provinz:";
var xmsgRegText=	"Region:";
var xmsgPrefectureText=	"Verwaltungsbezirk:";
var xmsgCountyText=	"Land:";
var xmsgCantonText=	"Kanton:";
var xmsgZipCode=	"Postleitzahl:";
var xmsgPostCode=	"Postleitzahl:";
var xmsgCountry=	"Land oder Region:";
var xmsgDealer=		"Name des autorisierten Autodesk-Vertragshändlers:";
var xmsgMailTo=		"Post an ";
var xmsgAnEmail=	"eine E-Mail-Adresse";
var xmsgAFax=		"eine Faxnummer";
var xmsgAMailAddress=	"eine Postadresse";
var xmsgPostalMail=		"Postsendung";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"<< Zurück";
var xmsgCancel=			"Schließen";
var xmsgNext=			"Weiter >>";
var xmsgPrint=			"Drucken";
var xmsgPrintForm=		"Formular für Aktivierungsanforderung öffnen";
var xmsgNo=				"Nein";
var xmsgYes=			"Ja";
var xmsgBrowse=			"Durchsuchen";
var xmsgDone=			"Fertig";
var xmsgOK=				"OK";
var xmsgClose=			"Schließen";
var xmsgSubmit=			"Übermitteln";
var xmsgFinish=			"Beenden";
var xmsgReset=			"Alle löschen";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Bitte wählen ";
var xmsgPleaseSelect2=		"Wählen Sie unten eine Option, und klicken Sie auf Weiter.";
var xmsgSelectCountry=		"Land/Region, in dem/der das Produkt verwendet wird:";
var xmsgSelectCountry2=		"Land/Region:";
var xmsgInformation=		"Informationen";
var xmsgCompanyInfo=		"Firmeninformationen:";
var xmsgContactInfo=		"Kontaktinformationen:";
var xmsgResponseMethodInfo=	"Informationen zum Antwortverfahren:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"Verfahren der Formularübermittlung:";
var xmsgConfirmInfo=		"Bestätigung der Informationen";
var xmsgConfirmInfoTxt=		"Überprüfen Sie die folgenden Informationen. Klicken Sie unter Verwendung der angezeigten Informationen links auf ein Verfahren der Formularübermittlung, um fortzufahren, oder klicken Sie auf Zurück, um Änderungen vorzunehmen.";
var xmsgConfirmCustIDInfoTxt=		"Bestätigen Sie die nachfolgenden Informationen. Klicken Sie auf Weiter, um fortzufahren, oder auf Zurück, um Änderungen vorzunehmen.";
var xmsgCountryHdr=			"Produktregistrierung";
var xmsgCountryRegTo=		"Dieses Produkt wird registriert für:";
var xmsgCountryComp=		"eine Firma";
var xmsgCountryIndiv=		"eine Einzelperson";
var xmsgCountryUpgrade=		"Dies ist ein Upgrade";
var xmsgCountryUpgDetail=	"(Wenn Sie ein Subskriptionskunde sind, klicken Sie auf Nein.)";
var xmsgConnectHdr1=		"Verbinden";
var xmsgConnectHdr=		"Verbindung zum Internet herstellen";
var xmsgConnectMsg=		"Verbindung";
var xmsgConnectTxt=		"Es wurde keine Internet-Verbindung gefunden. Um einen Online-Antrag zu übermitteln, stellen Sie nun eine Verbindung zum Internet her.";
var xmsgConnectTxtOLT=    "Es wurde keine Internet-Verbindung erkannt. Um eine Lizenz zu übertragen, verbinden Sie sich jetzt mit dem Internet.";
var xmsgConnectTxt2=	"Sobald eine Internet-Verbindung hergestellt wurde, klicken Sie auf Weiter.";
var xmsgConnectTxt3=	"Um den Antrag auf eine andere Weise zu übermitteln, klicken Sie auf den folgenden Link:";
var xmsgConnectWarming=	"Die Übermittlung dieser Informationen kann eine Weile dauern. Bitte warten Sie.";
var xmsgTryAgain=		"Neuer Versuch";
var xmsgReEnterOld=		"Vorhergehende Seriennummer erneut eingeben";
var xmsgNewSernum3=		"Bitte geben Sie die neue Seriennummer ein, und klicken Sie auf Weiter.";
var xmsgNewSernum4=		"Ihre Testversion ist mit der Seriennummer 000-00000000 installiert worden, die nicht zur Registrierung verwendet werden kann. Falls Sie die Software gekauft haben, wurde bereits eine neue Seriennummer für Sie erstellt. Sie müssen bei der Aktivierung diese neue Seriennummer angeben, um die Software einsetzen zu können.";
var xmsgNewSernum5=		"Geben Sie Ihre Seriennummer oder Gruppen-ID ein:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "Geben Sie Ihren Produktschlüssel ein:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"Bestätigung der neuen Seriennummer:";
var xmsgNewSernum8=		"Geben Sie die neue Seriennummer ein";
var xmsgUseOtherMethod=		"Andere Registrierungsmethode";
var xmsgContactAutodesk=	"Autodesk kontaktieren";
var xmsgContactAutodeskLink="Um Autodesk zu kontaktieren, klicken Sie auf den folgenden Link:";
var xmsgContactOptions=		"Kontaktmöglichkeiten sind unten auf dieser Seite angezeigt.";

var xmsgPuchaseInfo1=		"Kaufinformationen";
var xmsgPuchaseInfo2=		"Sie haben sich entschieden, online zu kaufen."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"Klicken Sie auf Weiter, um fortzufahren, oder auf Abbrechen, wenn Sie den Vorgang nicht fortsetzen möchten."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"Registrierung - Aktivierung";
var xmsgRegTitleBuy=		"Online-Kauf von Autodesk-Produkten";
var xmsgRegTitleNSA=		"Netzwerklizenzaktivierung";
var xmsgRegInfo=		"Kundeninformationen";
var xmsgRegInfo2=		"Registrierungsmethode";
var xmsgRegInfo3=		"Bitte wählen Sie eine Registrierungsmethode, und klicken Sie auf Weiter.";
var xmsgRegmethod1=		"Direkt-Verbindung über das Internet";
var xmsgRegmethod3=		"Ich möchte meinen Aktivierungscode erhalten per:";
var xmsgRegmethod5=		"Post";
var xmsgRegmethod6=		"Klicken Sie unten auf Drucken, und senden Sie dieses Formular per Post an die folgende Anschrift:";
var xmsgRegmethod7=		"Fax";
var xmsgRegmethod8=		"Um ein Formular auszudrucken, das Sie per Fax an Autodesk unter %1 senden können, wählen Sie zuerst das Verfahren, durch das Sie Ihren Aktivierungscode erhalten wollen. Klicken Sie dann auf Drucken. Sie können dann das Formular per Fax an uns senden.";
var xmsgRegmethod9=		"E-Mail";
var xmsgRegmethod10NSA=		"Die nachfolgend gezeigten Registrierungs- und Lizenzserver-Informationen wurden automatisch in einer Datei gespeichert.";
var xmsgRegmethod10=		"Ihre Registrierungsinformationen wurden in der nachfolgenden Datei gespeichert, die dann für das Beenden des E-Mail-Prozesses verwendet wird (und die Sie daher nicht ändern sollten):";
var xmsgRegmethod11NSA=		"Sendet die Registrierungs- und Lizenzserver-Informationsdatei %1 per E-Mail an %2.";
var xmsgRegmethod11=		"Sendet die Registrierungs-Informationsdatei %1 per E-Mail an %2.";
var xmsgRegmethod12=		"Verändern Sie diese Datei nicht.<p>Sie sollten eine Kopie dieser Seite ausdrucken und sie an einem sicheren Ort aufbewahren. Sie benötigen diese Informationen, um den E-Mail-Prozess manuell zu beenden. <p>Sie können eine Kopie dieser Informationen für Ihre Unterlagen drucken. Klicken Sie auf Fertig, um die Anwendung zu beenden.";
var xmsgRegmethod13=		"Um %1 automatisch anzuhängen und an Autodesk zu senden, klicken Sie auf den nachfolgenden Link.";
var xmsgRegmethod14=		"Meine Anforderung per E-Mail senden";
var xmsgRegmethod15=		"Anmerkung: Die E-Mail-Adresse wird automatisch generiert. Senden Sie keine E-Mails an diese Adresse.";
var xmsgRegmethod16=		"Um sich per Fax oder per Post registrieren zu lassen, klicken Sie auf einen der nachfolgenden Links:";
var xmsgRegmethod17=		"Fehler beim Senden des E-Mails";
var xmsgRegmethod18NSA=		"Während das System die Registrierungs- und Lizenzinformationen automatisch senden wollte ist ein Fehler aufgetreten.";
var xmsgRegmethod18=		"Während das System die Registrierungsinformationen automatisch senden wollte ist ein Fehler aufgetreten.";
var xmsgRegmethod19=		"Um die Datei manuell per E-Mail zu senden:";
var xmsgRegmethod20NSA=		"Sendet die Registrierungs- und Lizenzserver-Informationsdatei %1 per E-Mail an %2.";
var xmsgRegmethod20=		"Sendet die Registrierungs-Informationsdatei %1 per E-Mail an %2.";
var xmsgRegmethod21=		"Verändern Sie diese Datei nicht.<p>Sie sollten eine Kopie dieser Seite ausdrucken und sie an einem sicheren Ort aufbewahren. Sie benötigen diese Informationen, um den E-Mail-Prozess manuell zu beenden. <p>Sie können eine Kopie dieser Informationen für Ihre Unterlagen drucken. Klicken Sie auf Fertig, um die Anwendung zu beenden.";
var xmsgRegAuthInfo=		"Aktivierung";
var xmsgRegAuthInfo1=		"Registrierungsbestätigung";
var xmsgRegExpConfirm=      "Lizenzexportbestätigung";
var xmsgRegImpConfirm=      "Lizenzimportbestätigung";
var xmsgRegAuthInfo2=		"Aktivierungscode erhalten";
var xmsgRegAuthInfo3=		"Aktivierungscode eingeben"; 
var xmsgRegAuthInfo4=		"Wählen Sie unten eine Option:";
var xmsgRegAuthInfo4A=		"Einen Aktivierungscode eingeben";
var xmsgRegAuthInfo4B=		"Aktivierungscode eingeben:"; 
var xmsgRegAuthInfo5=		"Bitte wählen Sie Ihr Land oder Ihre Region, geben Sie den Aktivierungscode ein, und klicken Sie auf Weiter.";
var xmsgRegAuthInfo6=		"Registrierung - Aktivierungsbestätigung";	
var xmsgRegAuthInfo7=		"Vielen Dank für Ihre Registrierung und die Aktivierung des Produkts.";
var xmsgRegAuthInfo8=		"Bestätigung";		
var xmsgRegAuthInfo9=		"Vielen Dank für die Registrierung Ihres Autodesk-Produkts. Auf diese Weise helfen Sie uns, Ihren Wünschen in Zukunft noch besser gerecht zu werden.";
var xmsgRegAuthInfo10=		"Eine Kopie Ihrer Registrierungsinformationen wurde unter folgendem Speicherplatz gespeichert:";		
var xmsgRegAuthInfo10B=		"Eine Kopie Ihrer Registrierungsinformationen wurde unter folgendem Speicherplatz gespeichert:";
var xmsgRegActLicInfo=      "Aktivierte Lizenz gefunden";
var xmsgRegActLicInfoError=      "Registrierungs-/Aktivierungsfehler";
var xmsgRegActiveInfo=        "Wechseln Sie zur Aktivierungsdatei, oder geben Sie sie ein:";
var xmsgRegActLicInfo1=       "Eine bereits registrierte und aktivierte Lizenz für Ihr Produkt wurde auf diesem Computer gefunden. Vielen Dank."
var xmsgRegActLicInfo1Error= "Eine bereits registrierte und aktivierte Lizenz für Ihr Produkt wurde auf diesem Computer gefunden.\n Es ist jedoch ein unerwarteter Fehler (%1) aufgetreten. Bitte schließen Sie die Anwendung, und versuchen Sie es erneut. Falls dieses Problem andauert, wenden Sie sich an Ihren Systemadministrator oder autorisierten Autodesk-Fachhändler.";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "Export erfolgreich"; //2008-01-16
var xmsgExportFail=           "Fehler bei Exportanforderung" ; //2008-01-16
var xmsgRegErrRef=            "Fehlereferenz:"; //2008-01-17
var xmsgImportSuccess=        "Import erfolgreich"; //2008-01-16
var xmsgImportFail=           "Fehler bei Importanforderung"; //2008-01-16
var xmsgExpSucessInfo=        "Ihre Lizenz wurde exportiert und befindet sich jetzt auf dem Autodesk-Server."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "So importieren Sie Ihre Lizenz";
var xmsgExpSucessInfo1=        "Bevor Sie das Produkt auf dem Zielcomputer ausführen, importieren Sie diese Lizenz mithilfe des Lizenzübertragungsdienstprogramms auf diesen Computer, und halten Sie sich zur Eingabe Ihrer Autodesk-Benutzerkennung und des Kennworts bereit.";  //2008-01-16
var xmsgImpSucessInfo=         "Die Lizenz wurde importiert; Sie dürfen dieses Produkt jetzt benutzen. "; //2008-01-16
var xmsgImpRemindInfo=         "Ich möchte an den Export erinnert werden."; //2008-01-16
var xmsgImpRemindInfo1=        "Wenn Sie dieses Kästchen aktivieren, wird beim Beenden des Programms stets ein Dialogfeld angezeigt, das Sie daran erinnert, die Lizenz zu exportieren.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "Dies ist nützlich, wenn Sie die Lizenz temporär auf diesen Computer importieren und sie wieder zurück übertragen müssen.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "Eine \"Nicht-mehr-anzeigen\"-Option ist in der Erinnerung verfügbar.";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "Klicken Sie auf die \"Erneut-versuchen\"-Verknüpfung, um die Anforderung erneut zu senden. ";
var xmsgImpFailMsg=            "Falls das Problem andauert, sollten Sie die Lizenz aktivieren anstatt sie zu importieren.";

var xmsgReqfilelocMsg=       "Die Anforderungsdatei befindet sich unter:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"Danke, dass Sie sich registriert haben. Ihr Produkt ist nun aktiviert, und Ihre Lizenzdatei wurde gespeichert. Klicken Sie auf Drucken, um diese Informationen bei Ihren Unterlagen aufzubewahren.";
var xmsgRegAuthInfo12=		"Fügen Sie den Aktivierungscode ein.";
var xmsgRegAuthInfo13=		"Geben Sie den Aktivierungscode ein.";
var xmsgRegErrorActiveCode=    "<FONT color=red>Aktivierungscode eingeben, um fortzufahren.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>Der Aktivierungscode ist ungültig. Überprüfen Sie den Code auf Fehler.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>Pfad und Namen der Aktivierungsdatei eingeben, um fortzufahren.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>Eine Seriennummer eingeben, um fortzufahren.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>Die Seriennummer ist zu kurz.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>Einen Produktschlüssel eingeben, um fortzufahren.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>Der Produktschlüssel ist zu kurz.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"Registrierungs-/Aktivierungsfehler";
var xmsgRegErrorSystem=		"Ein vorübergehendes Systemproblem verursacht Probleme in Ihrer Registrierung. Klicken Sie auf eine der folgenden Verknüpfungen."
var xmsgRegErrorPrevReg=	"Diese von Ihnen eingegebene Seriennummer ist bereits registriert.";
var xmsgRegErrorMaxAuth=	"Sie haben die Anzahl der für dieses Produkt zulässigen Aktivierungen überschritten.";
var xmsgRegErrorMaxAuth2=	"Sie haben die Anzahl der für dieses Produkt zulässigen Lizenzen überschritten.";
var xmsgRegErrorInvalidOld=	"Die für das vorherige Produkt eingegebene Seriennummer ist ungültig. Überprüfen Sie, ob die bisherige und oben angezeigte Seriennummer richtig ist. Klicken Sie auf eine der folgenden Verknüpfungen.";
var xmsgRegErrorData=		"Die von Ihnen eingegebenen Registrierungsdaten verursachen ein Problem. Um fortzufahren, wählen Sie Erneut versuchen, um die eingegebenen Informationen zu überprüfen und zu korrigieren, oder wählen Sie ein anderes Registrierungsverfahren, oder wenden Sie sich an Autodesk.";
var xmsgRegErrorNetwork=	"Das Produkt, das Sie registrieren möchten, ist netzwerkautorisiert und muss entsprechend installiert werden. Sie müssen die Software deinstallieren und bei der Auswahl der Installationsart die Netzwerkoption wählen.<p>Weitere Informationen über die richtigen Installations- und Aktivierungsverfahren der Netzwerkversion finden Sie im Netzwerkinstallationsabschnitt des Installationshandbuchs.";
var xmsgRegNoResponse=		"Aufgrund einer zeitweisen Störung kommt es bei Ihrer Online-Registrierung zu Fehlern. Klicken Sie auf eine der folgenden Verknüpfungen.";
var xmsgRegErrorAuthEntry=	"Der eingegebene Aktivierungscode ist nicht korrekt. Klicken Sie auf eine der folgenden Verknüpfungen.";
var xmsgRegErrorAuthPermission = "Um dieses Autodesk-Produkt zu aktivieren, benötigen Sie Administratorrechte bzw. Ihr Administrator muss Ihnen erweiterte Rechte gewähren. Weitere Informationen über Adminstratorrechte oder erweiterte Rechte erhalten Sie von Ihrem Administrator.";							
var xmsgRegErrorAuth=		"Der Aktivierungscode ist fehlerhaft. Klicken Sie auf eine der folgenden Verknüpfungen.";
var xmsgRegErrorFlex=		"Im Zusammenhang mit der Lizenz ist ein Problem aufgetreten. Klicken Sie auf eine der folgenden Verknüpfungen.";
var xmsgRegConnError=		"Verbindungsfehler";
var xmsgRegConnErrorTxt=	"Bei der Internetverbindung ist ein Problem aufgetreten. Klicken Sie auf eine der folgenden Verknüpfungen.";
var xmsgRegPurchError3=		"Wählen Sie ein anderes Kaufverfahren.";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Danke, dass Sie die Autodesk-Software erworben haben.<p>Momentan steht keine Verbindung zur Verfügung, um den Prozess abzuschließen. Dies ist vermutlich auf Ihre Systemeinstellungen zurückzuführen.<p>Wenn Sie auf einen der unten aufgeführten Links klicken, wird Ihr Browser geöffnet und möglicherweise eine Verbindung hergestellt.<p>";

var xmsgAuthResellerMsg1=	"Kaufen Sie bei Ihrem lokalen Fachhändler. Kontaktieren Sie Ihren lokalen Fachhändler, um den Kauf zu vervollständigen.";

var xmsgLicSaveErrInfo=		"Beim Speichern Ihrer Lizenzdatei ist ein Fehler aufgetreten. Klicken Sie auf eine der folgenden Verknüpfungen.";

var xmsgOnlineStoreMsg1=	"Kaufen Sie im Autodesk Online-Shop. Wenn Sie das gewünschte Produkt im Shop nicht finden, wenden Sie sich bitte an Ihren autorisierten Fachhändler.";
var xmsgOnlineStoreMsg2=    "Online Store";
var xmsgAuthResellerMsg2=	"Autorisierter Fachhändler";
var xmsgLocateLicenseMsg1=	"Lizenzdatei suchen";
var xmsgLocateLicenseMsg2=	"Geben Sie einen Pfad zur Lizenzdatei ein (oder suchen Sie diese), und klicken Sie dann auf Weiter, um fortzufahren.";
var xmsgLocateLicenseMsg3=	"Vorhandene Lizenzdatei:";
var xmsgUserContactMsg=		"Sie müssen mindestens eine der folgenden Daten eingeben:";
var xmsgFailureMsg=		    "Ihr Online-Aktivierungsanforderung konnte nicht verarbeitet werden.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "Ihre Online-Aktivierungsanforderung hat den Fehler (%1) ausgegeben, wodurch Ihre Anforderung nicht in unseren automatischen Systemen bearbeitet werden kann.";
var xmsgRegErrorOnline=		"Klicken Sie auf \"Anderes Verfahren wählen\", um die erforderlichen Formulare auszufüllen und Ihre Anforderung an das für Ihre Region zuständige Autodesk Business Center zu übermitteln. Ein Kundendienstrepräsentant wird innerhalb der nächsten 2 Geschäftstage antworten.";
var xmsgAnotherFormSubmitMethod=    "Anderes Verfahren wählen";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "Zeitüberschreitung bei Ihrer Online-Aktivierungsanforderung."
var xmsgTimeoutMsg2=    "Klicken Sie auf \"Neuer Versuch\", um die Online-Anforderung erneut zu übermitteln. Besteht das Problem weiterhin, können Sie auf \"Anderes Verfahren wählen\" klicken, um die notwendigen Formulare auszufüllen und Ihre Anforderung mittels E-Mail, Fax oder Nutzung sonstiger Optionen zu übermitteln.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Registrierungsdaten gespeichert";
var xmsgRegSunData2=		"Die für die Client-Einrichtung erforderlichen Registrierungsdaten wurden gespeichert unter ";
var xmsgRegSunData3=		"Die bisherige Seriennummer, die für diese Upgrade-Registrierung geliefert wurde, ist ungültig. Wenden Sie sich bitte an Ihren Administrator.";
var xmsgRegSunData4=		"Die Software muss mit der gültigen bisherigen Seriennummer erneut installiert werden.";
var xmsgRegSunData5=		"Mehrplatz-Einzeleinrichtung";
var xmsgRegSunData6=		"Um die Mehrplatz-Einzeleinrichtung zu beenden, sind einige Registrierungsinformationen erforderlich. Die folgenden Seiten werden:";
var xmsgRegSunData7=		"Erforderliche Informationen sammeln";
var xmsgRegSunData8=		"Eingabe der bisherigen Seriennummer zulassen, falls für ein Upgrade erforderlich";
var xmsgRegSunData9=		"Informationen auf dem Server speichern, für die Einrichtung aller Client-Installationen";
var xmsgRegSunData10=		"Diese Software wird unter Verwendung der nachfolgenden Informationen registriert. Klicken Sie auf Weiter, um fortzufahren.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Produktregistrierung";
var xmsgRegVol2=	"Wählen Sie eine Option und klicken Sie auf Weiter:";
var xmsgRegVol3=	"Jetzt registrieren - wählen Sie diese Option, um mit der Online-Registrierung zu beginnen.";
var xmsgRegVol4=	"Später registrieren - wählen Sie diese Option, um die Software jetzt zu starten.";
var xmsgRegVol5=	"Dies nicht mehr anzeigen.";
var xmsgRegVol6=	"(Wenn Sie sich später registrieren wollen, können Sie die Registrierungsoption im Dialogfeld Info über AutoCAD (unter ? > Info über AutoCAD) wählen.)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Kundenidentifizierung";
var xmsgKatakana=		    "Firmenname (Zenkaku Kana):";
var xmsgDepartment=		    "Abteilung:";
var xmsgDepartment2=		"Abteilungsname:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"Im Internet:";
var xmsgFormWebDataMsg1= "Sie können einen Aktivierungscode auch unter folgendem Link erhalten:<br>";
var xmsgFormEmailHdr=	"E-Mail:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"Fax:";
var xmsgFormFaxHdrLocal=	"Fax an Autodesk-Niederlassung:";
var xmsgFormFaxHdrReg=	"Fax-Registrierung:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Telefon:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Postsendung:";
var xmsgFormMailHdrLocal=	"Post an Autodesk-Niederlassung:";
var xmsgFormMailHdrReg=	"Post-Registrierung:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Software erwerben";
var xmsgFormInternetMsg=    "Um Ihren Webbrowser zur Anforderung eines Aktivierungscodes zu benutzen, klicken Sie auf die Verknüpfung."
var xmsgFormEmailMsg=       "E-Mail-Korrespondenz und Aktivierungsanforderungen an:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "Die von Ihnen zur Verfügung gestellten Informationen werden von Autodesk verwendet, um Sie zu registrieren und/oder Ihren Aktivierungscode auszugeben. Mit der Registrierung geben Sie Ihre Zustimmung, dass Autodesk zum Zweck der Produktlizenzverwaltung sowie der Berechtigungsverifizierung Informationen über Sie an die autorisierten Geschäftspartner weitergibt. Wenn Sie die Weitergabe ausschließlich für diese Zwecke nicht wünschen, wenden Sie sich bitte unter <a href=mailto:information@autodesk.jp>information@autodesk.jp</a> an Autodesk. Wenn Sie Ihre Registrierungsdaten korrigieren oder aktualisieren möchten, klicken Sie bitte <a %1>HIER</a>, um Autodesk zu kontaktieren, oder wenden Sie sich an die Autodesk-Niederlassung in Ihrer Nähe.";
			
var privacystatement = "Die von Ihnen zur Verfügung gestellten Informationen werden von Autodesk verwendet, um Sie zu registrieren und/oder Ihren Aktivierungscode auszugeben, um Sie über Produkte und Service zu informieren, und um sicherzustellen, dass Sie alle Vorzüge eines autorisierten Autodesk-Benutzers genießen. Autodesk wird diese Informationen weder verkaufen noch an Personen außerhalb von Autodesk bzw. von unseren autorisierten Geschäftspartnern weitergeben. Wenn Sie die zuvor registrierten Kundeninformationen korrigieren oder aktualisieren wollen, klicken Sie bitte <a %1>HIER</a>, um Autodesk zu kontaktieren, oder wenden Sie sich an die Autodesk-Niederlassung in Ihrer Nähe.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="Datenschutzrichtlinien";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) Copyright 2009 Autodesk, Inc. Alle Rechte vorbehalten."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="In den meisten Fällen wird die neue Seriennummer nicht angezeigt, bis Sie das Programm schließen und mit Administratorrechten neu starten.";
var xmsgRebranding2="Informationen über den Start von Programmen mit Administratorrechten finden Sie in der Betriebssystemdokumentation.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "Die mit <FONT color=red>*</FONT> markierten Felder sind erforderlich.";
var xmsgRegInfoMsg2= "Die auf dieser Seite von Ihnen eingegebenen Informationen werden zusammen mit Ihrer Lizenz gespeichert. Sie werden für die Produkt-Reaktivierung und für Upgrades verwendet. Stellen Sie sicher, dass Sie korrekte Informationen eingeben, um Verzögerungen bei der Nutzung Ihres Produkts zu vermeiden.";

var xmsgLicLocationText1 = "Lizenzdatei für <b>%1</b> speichern unter:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"Fragen:";

var xmsgAppUsageQ1=	"Damit Autodesk die Anforderungen Ihrer Branche besser versteht, beantworten Sie bitte die folgende Frage.";
var xmsgAppUsageQ2=	"Welcher der folgenden Einträge beschreibt Ihr primäres Tätigkeitsfeld am besten?";

var xmsgAppUsageOption51=	"Luftfahrt- und KFZ-Komponentenentwurf";
var xmsgAppUsageOption52=	"Architektonischer Entwurf ";
var xmsgAppUsageOption53=	"Gebäude- und Anlagenverwaltung";
var xmsgAppUsageOption54=	"Bauwesen: Gewerbegebäude";
var xmsgAppUsageOption55=	"Bauwesen: Wohngebäude";
var xmsgAppUsageOption56=	"Herstellung von Baumaschinen ";
var xmsgAppUsageOption57=	"Tiefbau/Landschaftsplanung";
var xmsgAppUsageOption58=	"Entwurf von Computer-/medizinischen/Bürogeräten";
var xmsgAppUsageOption67=	"Konsumgüterentwurf";
var xmsgAppUsageOption59=	"Unternehmensgebäudebesitz";
var xmsgAppUsageOption92=	"Verteidigung";
var xmsgAppUsageOption93=	"Elektrische Steuerungen";
var xmsgAppUsageOption94=	"Elektrotechnik";
var xmsgAppUsageOption72=	"Umwelttechnik";
var xmsgAppUsageOption95=	"Vorgefertigte Metallprodukte";
var xmsgAppUsageOption96=	"Innenarchitektur ";
var xmsgAppUsageOption97=	"Maschinenbau ";
var xmsgAppUsageOption98=	"Herstellungsbeschaffung/Verkauf/Marketing";
var xmsgAppUsageOption40=	"Kartografie und Geodatenentwurf ";
var xmsgAppUsageOption41=	"Mechanische Systeme (HLK und Rohrsysteme)";
var xmsgAppUsageOption42=	"Sanitärinstallation und/oder Feuerschutzsysteme";
var xmsgAppUsageOption43=	"Anlagenbau und Kraftwerks-Entwicklung ";
var xmsgAppUsageOption44=	"Immobilienentwicklung";
var xmsgAppUsageOption45=	"Bautechnik";
var xmsgAppUsageOption87=	"Telekommunikation ";
var xmsgAppUsageOption46=	"Werkzeugmaschinen/Maschinenabteilung";
var xmsgAppUsageOption47=	"Transportplanung ";
var xmsgAppUsageOption48=	"Versorgungsunternehmen: Elektrizität, Öl und Gas ";
var xmsgAppUsageOption49=	"Versorgungsunternehmen: Wasser und Kanalisation";
var xmsgAppUsageOption99=	"Sonstige ";

var xmsgWrongCountryCodeMsg=	"Fehler: Unbekannte Ländercode-Eingabe!";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "Version:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"Ich sende meine Anforderung per Fax oder Telefon"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"Per Post registrieren.";
var xmsgAccessHereMsg=		"hier.";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "Ich möchte den Code erhalten von:";
var xmsgReceiveCodeMsg1=     "Ich möchte meine Aktivierungsdatei per E-Mail erhalten"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"Bitte warten Sie, während Ihre Lizenz <br>überprüft wird.";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "Produktinformation"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "Alle Felder müssen ausgefüllt werden."; //add by joyce.min on 2007-8-14
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"Eine Netzwerklizenz erhalten";
var xmsgNSARTBeginMsg1=		"Fordern Sie hier eine Datei zur Aktivierung der Netzwerklizenz an: ";
var xmsgNSARTBeginMsg2=		"Direkt verbinden (über das Internet)";
var xmsgNSARTBeginMsg3=		"Anforderung per E-Mail, Fax oder Telefon senden";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"Server-Informationen";
var xmsgEditServerHdrMsg2=	"Lizenz-Servermodell*";
var xmsgEditServerMsg1=		"Geben Sie Ihre Lizenzserver-Informationen ein. Wenn Sie auf die Schaltfläche Suchen klicken, werden mehrere Einträge im Server-Host-ID-Feld angezeigt.<p>";
var xmsgEditServerMsg2=		"Beginnen Sie mit Server-Host-Daten von der/den bestehenden Lizenzdatei(en).";
var xmsgEditServerRemove=	"Entfernen";
var xmsgEditServerHostName=	"Server-Host-Name*";
var xmsgEditServerHostID=	"Host-ID*";
var xmsgEditServerSeat=		"Sitze*";
var xmsgEditServerSingle=	"Einzelserver";
var xmsgEditServerDistributed=	"Verteilter Server";
var xmsgEditServerRedundant=	"Redundanzserver";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"Suche";
var xmsgEditServerAddServer=	"Hinzufügen";
var xmsgEditServerRemoveServer=	"Entfernen";
var xmsgEditServerTotal=	"Gesamt:";
var xmsgEditServerExceedMaxServer=	"Anmerkung: Sie können maximal 20 verteilte Server gleichzeitig lizenzieren. Wenn Sie mehr als 20 Server lizenzieren müssen, wenden Sie sich an Autodesk.";
var xmsgEditServerSeatError=	"Sitze dürfen nur numerische Werte enthalten.";

var xmsgConfirmServerMsg=	"Überprüfen Sie die nachfolgenden Informationen. Klicken Sie auf Weiter, um fortzufahren oder auf Zurück, um Änderungen vorzunehmen.";
var xmsgConfirmServerMsg2=	"Wenn Sie auf Weiter klicken, werden diese Informationen über das Internet an Autodesk gesendet.";
var xmsgConfirmServerHdr2=	"Lizenz-Servermodell:";
var xmsgConfirmServerHostName=	"Server-Host-Name";
var xmsgConfirmServerHostID=	"Host-ID";
var xmsgConfirmServerSeat=		"Sitze";
var xmsgConfirmServerTotal=		"Gesamtzahl der Sitze:";

var xmsgLicErrorHdr=			"Lizenzierungsfehler"; 
var xmsgLicErrorInvalidSN=		"Die eingegebene Seriennummer ist ungültig. Überprüfen Sie, ob die oben angezeigte Seriennummer richtig ist. Klicken Sie auf eine der folgenden Verknüpfungen.";
var xmsgLicReEnterSN=			"Geben Sie die Seriennummer erneut ein, und versuchen Sie es erneut.";

var xmsgLic113Msg2=				"Die Gesamtzahl der Sitze, die Sie Ihren verteilten Servern zugewiesen haben, überschreitet diese Zahl.";
var xmsgLic113ModifySeats=		"Ändern Sie die Sitzverteilung.";

var xmsgSaveLicenseHdr=			"Erhaltene Lizenz(en)";
var xmsgSaveLicenseMsg1=		"Sie haben Ihre Lizenzen von Autodesk erhalten. Sie müssen sie nun als Lizenzdateien speichern.<p> <b>Lizenz(en) als Lizenzdateien speichern</b><p><LI>Der <b>empfohlene Speicherort</b> Ihrer Lizenzdatei(en) ist im Verzeichnis \"Licenses\", wo Sie Autodesk Network License Manager auf Ihrem Server installiert haben.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"</LI><p><LI>Wenn Sie eine <b>bestehende Lizenzdatei</b> besitzen, sollten Sie die neue Lizenz in diese <b>einfügen</b>.<br>Wenn Sie auf Weiter klicken, fügt das System Ihre Lizenzinformationen automatisch in die bestehende Datei unter dem richtigen Speicherort ein.</LI>";
var xmsgSaveLicenseMsg2=		"Wenn die oben genannte Datei eine bestehende Lizenzdatei ist:";
var xmsgSaveLicenseMsg3=		"Fügen Sie die neuen Lizenzinformationen in diese ein.";
var xmsgSaveLicenseMsg4=		"Überschreiben Sie die bestehende Lizenzdatei.";
var xmsgSaveLicenseMsg5=		"Korrigieren Sie bitte die folgenden Fehler:";

var xmsgSaveErrorFileNameTooLong=  "FEHLER: Der eingegebene Dateiname ist zu lang.<br>" +
								"Dateinamen ändern und fortfahren.";
var xmsgSaveErrorNoPermission=	"FEHLER: Sie verfügen nicht über die notwendigen Rechte, um die Datei unter diesem Speicherort zu speichern.<br>Sie können die Datei unter einem temporären Speicherort speichern, die erforderlichen Rechte anfordern und die Datei später verschieben.";
var xmsgSaveErrorNoDiskSpace=	"FEHLER: Sie verfügen nicht über genügend Speicherplatz, um die Datei unter dem angegebenen Speicherort zu speichern.<BR>Sie können die Datei unter einem temporären Speicherort speichern, Speicherplatz freimachen und die Datei später verschieben.";
var xmsgSaveErrorInvalidFile=	"FEHLER: Die neue Lizenz konnte nicht an die angegebene Datei angehängt werden, ohne dabei Daten zu verlieren.  Die angegebene Datei ist möglicherweise für andere Geräte oder Servermodelle vorgesehen.<BR>Sie können die neue Lizenzdatei unter einem anderen Namen oder Speicherort speichern und sie später manuell zur Datei hinzufügen.";															
var xmsgSaveErrorPathNotExit=	"FEHLER: Der angegebene Pfad existiert nicht.<BR>Klicken Sie auf die Schaltfläche Durchsuchen, um den Pfad zu suchen oder zu erstellen.";
var xmsgSaveErrorPathBlank=		"FEHLER: Sie müssen einen gültigen Pfad und Lizenzdateinamen angeben. Geben Sie den Pfad und Dateinamen in das unten angezeigte Feld ein, oder suchen bzw. erstellen Sie diese.";

var xmsgLicAuthConfirmHdr1=		"Lizenzaktivierung erfolgreich!";
var xmsgLicAuthConfirmHdr2=		"Lizenz-Server-Host-Informationen";
var xmsgLicAuthConfirmMsg1=		"Danke, dass Sie Ihr Produkt haben registrieren lassen. Sie können diese Informationen ausdrucken.";
var xmsgLicAuthConfirmDate=		"Datum:";

var xmsgLicPathMsg1=			"Die folgenden Lizenzdateien wurden gespeichert:";
var xmsgLicPathMsg2=			"Ihre Lizenzdateien wurden gespeichert unter:";

var xmsgOtherMethodMsg1NSA=		"Verwenden Sie ein anderes Verfahren, um eine autorisierte Lizenz zu erhalten.";
var xmsgOtherMethodMsg1=		"Anderes Verfahren verwenden";

var xmsgContactAutodeskMsg1=	"Verwenden Sie eine der folgenden Methoden, um Autodesk zu kontaktieren.";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"Lizenzdatei per E-Mail erhalten";
var xmsgEmailOptionTitle=		"Per E-Mail registrieren";
var xmsgEmailOptionNSAMsg=		"Ihre Registrierungs- und Lizenzserver-Informationen wurden automatisch in einer Datei gespeichert. Die Datei muss per E-Mail an Autodesks automatisiertes Registrierungsverarbeitungs-Center gesendet werden.<p>Wenn Sie die Datei erfolgreich an Autodesk senden, erhalten Sie eine automatische Antwort, eine autorisierte Lizenzdatei und Informationen, wie der Prozess beendet werden muss.";
var xmsgEmailOptionMsg=			"Ihre Registrierungs-Informationen wurden automatisch in einer Datei gespeichert. Die Datei muss per E-Mail an Autodesks automatisiertes Registrierungsverarbeitungs-Center gesendet werden.<p>Wenn Sie die Datei erfolgreich an Autodesk senden, erhalten Sie eine automatische Antwort und Informationen, wie der Prozess beendet werden muss.";
var xmsgEmailOptionMsg2=		"Wenn das von Ihnen verwendete E-Mail-System momentan E-Mails über das Internet senden kann, klicken Sie auf Datei jetzt senden und auf Weiter. Die Datei wird dann automatisch abgesendet.<p>Wenn Sie momentan nicht auf ein E-Mail-System zugreifen können, klicken Sie auf Datei später senden. Sie erhalten dann Informationen, wie Sie die Datei manuell senden können.";
var xmsgEmailOptionInfo1=		"Datei jetzt senden";
var xmsgEmailOptionInfo2=		"Datei später senden";
var xmsgEmailOptionInfo3=		"Kopie des E-Mails an die genannte E-Mail-Adresse senden";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"E-Mail kann nicht erstellt werden.";
var xmsgEmailErrorMsg1=			"Um die Registrierung per E-Mail abzuschließen, hängen Sie folgende Datei an eine E-Mail an:";
var xmsgEmailErrorMsg2=			"Senden Sie die E-Mail an %1.";
var xmsgEmailErrorMsg3=			"Sie finden die Datei an folgendem Speicherort:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"Kundeninformationen ändern";
var xmsgLocalHEREInfo=			"Um Ihre Kundeninformationen zu ändern, wenden Sie sich an Ihren autorisierten Autodesk-Fachhändler, oder navigieren Sie zu einem der nachfolgenden Links für Ihr Land bzw. Ihre Region.";
var xmsgLocalHEREUS=			"Amerika";
var xmsgLocalHEREEMEA=			"Europa, Naher Osten, Afrika";
var xmsgLocalHEREAPAC=			"Asien/Pazifischer Raum";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"Hilfe";
var xmsgHelpUpgradeMsg=			"Wenn Sie ein Upgrade einer früheren Version registrieren oder aktivieren, müssen Sie dieses Feld markieren; Sie werden dann aufgefordert, die Seriennummer der Version einzugeben, die Sie aktualisieren wollen.";
var xmsgHelpUpgradeRequiredTitle=	"Geben Sie die frühere Produktseriennummer ein (erforderlich für Upgrades)";
var xmsgHelpUpgradeRequiredMsg=	"Dies ist die Seriennummer Ihrer früheren Software-Version. Sie finden die Seriennummer entweder in der Software unter Hilfe > Info über..., oder auf der Verpackung Ihres früheren Produkts.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"Sie haben %1 nicht eingegeben. Bitte nehmen Sie diese Eingabe vor, falls Sie Ihre Aktivierung mittels dieser Methode erhalten möchten.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "Seriennummer/Gruppen-ID"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "Ihre Seriennummer entnehmen Sie bitte der Produktpackung oder der E-Mail mit Upgrade- und Lizenzierungsinformationen, die Sie von Autodesk erhalten haben."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "Produktschlüssel";
var xmsgHelpProductKeyMsg=    "Ihren Produktschlüssel finden Sie bei der Seriennummer auf der Produktpackung oder in der E-Mail mit Upgrade- und Lizenzierungsinformationen, die Sie von Autodesk erhalten haben."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"Verbindungsfehler (0.15)";
var xmsgRT010203071213CannotCompErrA=	"Registrierungsfehler (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"Bereits registriert (9)";
var xmsgRT10ExceededAuths=				"Autorisierungszahl überschritten (10)";
var xmsgRT12StolenSN=					"Gestohlene Seriennummer (12)";
var xmsgRT18OldSNInvalid=				"Bisherige Seriennummer ungültig (18)";
var xmsgRT20DataError=					"Datenfehler (20)";
var xmsgRT21CustIDTelErr=				"Fehler in Kunden-Nr./-Tel. (21)";
var xmsgRT22NetworkInstallation=		"Netzinstallierungsfehler (22)";
var xmsgRT900SystemNotResponding=		"System antwortet nicht (900)";
var xmsgRTCustID=						"Kunden-ID";
var xmsgRTCustIDConfirm=				"Identifizierung bestätigen";
var xmsgRTNewSerialNumber=				"Neue Seriennummer";
var xmsgRTNoNewSN=						"Kauftransaktionsfehler";
var xmsgRTPurchAuthFailed=				"Aktivierungsfehler";
var xmsgRTPurchConfirmOther=			"Kaufbestätigung";
var xmsgRTPurchConfirmPerm=				"Kaufbestätigung - registriert und aktiviert";
var xmsgRTPurchConfirmReg=				"Kaufbestätigung - registriert, aber nicht aktiviert";
var xmsgRTPurchConfirmRegVol=			"Kaufbestätigung - registriert";
var xmsgRTPurchConfirmRent=				"Kaufbestätigung - registriert und aktiver Zeitverleih";
var xmsgRTPurchConfirmUnReg=			"Kaufbestätigung - nicht registriert oder aktiviert";
var xmsgRTPurchConnectionFailed=		"Kaufverbindung gescheitert";
var xmsgRTPurchaseError=				"Fehler im Kaufvorgang";
var xmsgRTSNMismatch=					"Kauftransaktionsfehler - nicht übereinstimmende Seriennummern";
var xmsgRTSUNOldSNInvalid=				"Bisherige Seriennummer ungültig - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"Beenden";

var xmsgCustIDMainTitle=	"Kundenidentifizierung";
var xmsgCustIDTitle1=		"Kunden-ID:";
var xmsgCustIDText2=		"Geben Sie nachfolgend Ihre Kunden-ID und Telefonnummer ein. Wenn Sie keine Kunden-ID haben, lassen Sie beide Felder leer.<p> ";
var xmsgCustIDText3=		"Anmerkung: Wenn Sie das Produkt erneut aktivieren, müssen Sie eine Kunden-ID eingeben.";
var xmsgCustIDText3NSA=		"Anmerkung: Wenn Sie das Produkt erneut aktivieren, müssen Sie eine Kunden-ID eingeben.";
var xmsgCustIDTitle2=		"Telefonnummer:";
var xmsgCustIDTelEx4=		"(Beispiel: 03-111-1234)";
var xmsgRegCustIDTel=		"Die von Ihnen eingegebene Kunden-ID und Telefonnummer entsprechen nicht unseren Daten. Klicken Sie auf eine der folgenden Verknüpfungen.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"Aus unseren Datensätzen geht hervor, dass Sie über %1 gültige %2-Sitze verfügen.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"Die eingegebene Seriennummer ist ungültig.";
var xmsgErr12APAC=				"<p>Die eingegebene Seriennummer ist ungültig und kann nicht aktiviert werden. Bitte kontaktieren Sie uns unter <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a>.</p>";
var xmsgErr12EMEA=				"<p>Sehr geehrter Kunde,</p><p>vielen Dank, dass Sie Ihr Autodesk&#0174;- oder Discreet&#0153;-Softwareprodukt bei Autodesk registrieren möchten.</p><p>Leider hat ein Vergleich mit unserer Datenbank ergeben, dass die für das Autodesk&#0174;- oder Discreet&#0153;-Softwareprodukt eingegebene Seriennummer keine gültige Seriennummer oder die Seriennummer einer bekannten Raubkopie ist. Aus diesem Grund handelt es sich bei dem verwendeten Autodesk&#0174;- oder Discreet&#0153;-Softwareprodukt um eine nicht autorisierte Kopie.</p><p>Lizenzen für Autodesk&#0174;-Softwareprodukte können bei einem autorisierten Autodesk-Vertragshändler erworben werden. Unter <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> finden Sie eine Liste, mit deren Hilfe Sie sich über autorisierte Autodesk-Vertragshändler oder Autodesk-Niederlassungen in Ihrer Nähe informieren können. Die Verwendung legaler Software ist die einzige Möglichkeit, alle Vorteile der Software auszuschöpfen UND eine mögliche zivil- und strafrechtliche Verfolgung zu vermeiden, die eine illegale Verwendung und/oder illegale Vervielfältigung von Software nach sich ziehen kann.</p><p>Lizenzen für Discreet&#0153;-Softwareprodukte können Sie bei Ihrem autorisierten Discreet-Vertragshändler erwerben. Besuchen Sie bitte <a href=\"http://www.discreet.de\" target=\"_blank\">www.discreet.de</a>, um eine Liste der autorisierten Discreet-Vertragshändler in Ihrer Nähe angezeigt zu bekommen. Die Verwendung legaler Software ist die einzige Möglichkeit, alle Vorteile der Software auszuschöpfen UND eine mögliche zivil- und strafrechtliche Verfolgung zu vermeiden, die eine illegale Verwendung und/oder illegale Vervielfältigung von Software nach sich ziehen kann.</p><p>Wir bitten Sie daher eindringlich, das nicht autorisierte Softwareprodukt nicht weiter zu verwenden, alle auf Ihrem Computersystem gespeicherten Kopien zu entfernen und sämtliche Medien zu vernichten, die das Softwareprodukt enthalten. Wenngleich wir darauf vertrauen, dass Sie dieser Aufforderung freiwillig nachkommen, behält sich Autodesk das Recht vor, Ihre Daten an die Business Software Alliance (“BSA”) weiterzugeben.</p><p>Falls Sie Fragen haben oder der Meinung sind, dass Ihnen diese Nachricht zu Unrecht angezeigt wird, kontaktieren Sie uns unter: <a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a></p><p>Wenn Sie Hinweise zur Verwendung oder Verbreitung illegaler Software geben können, wenden Sie sich bitte an Ihr lokales Autodesk-Büro oder kontaktieren Sie die BSA unter <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a>.</p><p>Vielen Dank!</p>";
var xmsgErr12US=				"<p>Sehr geehrter Kunde,</p><p>Sie haben vor kurzem versucht, Ihr Softwareprodukt bei Autodesk oder Discreet zu registrieren.</p><p>Leider hat ein Vergleich mit unserer Datenbank ergeben, dass die für das Autodesk&#0174;- oder Discreet&#0153;-Softwareprodukt eingegebene Seriennummer keine gültige Seriennummer oder die Seriennummer einer bekannten Raubkopie ist. Aus diesem Grund handelt es sich bei dem verwendeten Autodesk&#0174;- oder Discreet&#0153;-Softwareprodukt um eine nicht autorisierte Kopie.</p><p>Lizenzen für Autodesk&#0174;-Softwareprodukte können bei einem autorisierten Autodesk-Fachhändler erworben werden – eine Liste der autorisierten Autodesk-Fachhändler in Ihrer Nähe erhalten Sie unter <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>.  Die Verwendung legaler Software ist die einzige Möglichkeit, alle Vorteile der Software auszuschöpfen UND eine mögliche zivil- und strafrechtliche Verfolgung zu vermeiden, die eine illegale Verwendung und/oder illegale Vervielfältigung von Software nach sich ziehen kann.<p><p>Discreet&#0153;-Benutzer können bei einem autorisierten Discreet-Fachhändler Lizenzen für Discreet&#0153;-Softwareprodukte erwerben – unter <a href=\"http://www.discreet.de\" target=\"_blank\">www.discreet.de</a> finden Sie eine Liste der Discreet-Fachhändler oder Discreet-Büros in Ihrer Nähe. Die Verwendung legaler Software ist die einzige Möglichkeit, alle Vorteile der Software auszuschöpfen UND eine mögliche zivil- und strafrechtliche Verfolgung zu vermeiden, die eine illegale Verwendung und/oder illegale Vervielfältigung von Software nach sich ziehen kann.</p><p>Wir bitten Sie daher eindringlich, das nicht autorisierte Softwareprodukt, das Sie bei uns zu registrieren versuchten, nicht weiter zu verwenden, alle auf Ihrem Computersystem gespeicherten Kopien zu entfernen und sämtliche Medien zu vernichten, die das Softwareprodukt enthalten. Wenngleich wir darauf vertrauen, dass Sie dieser Aufforderung freiwillig nachkommen, behält sich Autodesk das Recht vor, Ihre Daten an die Business Software Alliance (“BSA”) weiterzugeben.</p><p>Falls Sie Fragen haben oder der Meinung sind, dass Ihnen diese Nachricht zu Unrecht angezeigt wird, kontaktieren Sie uns unter: <a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p><p>Wenn Sie Hinweise zur Verwendung oder Verbreitung illegaler Software geben können, wenden Sie sich an Ihr lokales Autodesk-Büro oder kontaktieren Sie die BSA unter <a href=\"http://www.BSA.de\" target=\"_blank\">www.BSA.de</a>.</p><p>Vielen Dank!</p>";






// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFLSRzlf5UG7n
// SIG // 3WGePf+480SzC3rvoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFK+pFClYKoUcx5ZMCrgwX/LrW65AMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYAH
// SIG // oqCIlZnqih10k/880DBKbo95u6AqIrpHW9QYWf6tm2Zp
// SIG // G8VHVYN1N3/4uZhlKTuTbrSt8ywx5o4YcRI7YGMM2b7+
// SIG // N3/lF0mbSTdgrrBsWJxZNaNxpwci5gdFFzcpHlmrzI62
// SIG // u8ORpod6DHfACeqy8hW+T11+wdBYRfYkNwtkR6GCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjI1MjI2
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUCyBz5H8CkCQEVZvT591R
// SIG // UMmEvdgwDQYJKoZIhvcNAQEBBQAEgYAshxS4S3Mw/STR
// SIG // 1/l+Ce4Nj/ELqpQ2K+DL2NegYW4TMpM54hDJ9xbpS9bw
// SIG // 6csVs52nfjXy0zXwgIPrFcgrvshQyPYbGPyCYQ7d8MBd
// SIG // i29SOFaP+s4DDl4FDB86MGtTw+ZzissC2yjwSVSAli3C
// SIG // mXwzUBBp14qv3151ZRdGgfznCA==
// SIG // End signature block
